rule Win32_Ransomware_FarAttack : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "FARATTACK"
        description         = "Yara rule that detects FarAttack ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "FarAttack"
        tc_detection_factor = 5

    strings:

        $find_files = {
            56 FF 73 ?? FF 15 ?? ?? ?? ?? 89 45 ?? 83 F8 ?? 75 ?? 50 FF 15 ?? ?? ?? ?? 56 E8 ??
            ?? ?? ?? 59 6A ?? 58 E9 ?? ?? ?? ?? 8D 46 ?? 50 FF 15 ?? ?? ?? ?? 89 45 ?? 03 C7 89
            45 ?? 3D ?? ?? ?? ?? 0F 8D ?? ?? ?? ?? F7 06 ?? ?? ?? ?? 0F 85 ?? ?? ?? ?? 8D 4E ??
            51 68 ?? ?? ?? ?? 6A ?? FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ??
            83 F8 ?? 0F 84 ?? ?? ?? ?? F6 06 ?? 74 ?? 8B 45 ?? 8D 04 45 ?? ?? ?? ?? 50 8D 46 ??
            50 8B 43 ?? 8D 04 78 83 C0 ?? 50 E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 83 C4 ?? 8B 53 ??
            8B 75 ?? 8B 01 53 89 44 72 ?? 66 8B 41 ?? 8B CE 66 89 44 4A ?? FF 43 ?? 83 63 ?? ??
            E8 ?? ?? ?? ?? FF 4B ?? 83 63 ?? ?? 8B 75 ?? E9 ?? ?? ?? ?? 83 7B ?? ?? 75 ?? FF 73
            ?? FF 73 ?? FF 73 ?? FF 73 ?? 57 FF 73 ?? E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 74 ?? C7 43
            ?? ?? ?? ?? ?? 8D 46 ?? 50 FF 15 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 6A ?? FF 35 ?? ?? ??
            ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 83 F8 ?? 0F 84 ?? ?? ?? ?? 8B 45 ?? 8D
            04 45 ?? ?? ?? ?? 50 8D 46 ?? 50 8B 43 ?? 8D 04 78 83 C0 ?? 50 E8 ?? ?? ?? ?? 83 C4
            ?? 83 7E ?? ?? 75 ?? 83 7E ?? ?? 74 ?? 6A ?? E8 ?? ?? ?? ?? 8B F8 8B 45 ?? 8D 34 00
            8D 4E ?? 51 E8 ?? ?? ?? ?? 56 89 07 FF 73 ?? 50 E8 ?? ?? ?? ?? 8B 07 33 C9 83 C4 ??
            66 89 0C 06 8B 75 ?? 51 57 51 8B 46 ?? 89 47 ?? 8B 46 ?? 89 47 ?? 8B 45 ?? 89 47 ??
            FF 73 ?? FF 15 ?? ?? ?? ?? 8B 7D ?? 8B 4B ?? A1 ?? ?? ?? ?? 89 44 79 ?? 66 A1 ?? ??
            ?? ?? 66 89 44 79 ?? 56 FF 75 ?? FF 15
        }

        $create_key = {
            55 8B EC 56 6A ?? E8 ?? ?? ?? ?? 8B F0 59 85 F6 75 ?? 32 C0 EB ?? A1 ?? ?? ?? ?? 53
            33 DB 85 C0 74 ?? 53 6A ?? 53 53 56 FF D0 EB ?? 8A C3 84 C0 75 ?? FF 15 ?? ?? ?? ??
            3D ?? ?? ?? ?? 75 ?? A1 ?? ?? ?? ?? 85 C0 74 ?? 6A ?? 6A ?? 53 53 56 FF D0 8A D8 84
            DB 75 ?? 56 E8 ?? ?? ?? ?? 59 32 C0 EB ?? 8B 4D ?? B0 ?? 89 71 ?? 5B 5E 5D C3
        }

        $encrypt_files_p1 = {
            50 68 ?? ?? ?? ?? 6A ?? 50 50 68 ?? ?? ?? ?? 57 FF 15 ?? ?? ?? ?? 8B F8 89 7D ?? 83
            FF ?? 0F 84 ?? ?? ?? ?? 8B 45 ?? 0B 45 ?? 0F 84 ?? ?? ?? ?? 8B 45 ?? 8B 48 ?? 8B 40
            ?? 83 C1 ?? 03 C1 8B 5D ?? 89 5D ?? 8B 4D ?? 89 4D ?? 99 03 D8 89 5D ?? 13 CA 89 4D
            ?? 8B 55 ?? 8B 45 ?? 85 D2 7C ?? 7F ?? 3D ?? ?? ?? ?? 76 ?? 89 75 ?? EB ?? 83 65 ??
            ?? 85 D2 7C ?? 7F ?? 3D ?? ?? ?? ?? 76 ?? 89 75 ?? EB ?? 83 65 ?? ?? C7 45 ?? ?? ??
            ?? ?? 83 7D ?? ?? 74 ?? 6A ?? 6A ?? 52 50 E8 ?? ?? ?? ?? 6A ?? 6A ?? 59 89 4D ?? 51
            52 50 E8 ?? ?? ?? ?? 89 45 ?? 89 55 ?? 8B 4D ?? 6A ?? 53 51 6A ?? 6A ?? 57 FF 15 ??
            ?? ?? ?? 8B D8 89 5D ?? 85 DB 0F 84 ?? ?? ?? ?? 83 FB ?? 0F 84 ?? ?? ?? ?? B8 ?? ??
            ?? ?? 89 45 ?? 89 45 ?? 33 C9 8B C1 89 45 ?? 89 45 ?? 89 4D ?? 89 4D ?? 89 45 ?? 89
            45 ?? 89 4D ?? 8B 4D ?? FF 71 ?? 6A ?? 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ??
            84 C0 0F 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8
            ?? ?? ?? ?? 83 C4 ?? 85 C0 0F 85 ?? ?? ?? ?? 8B 4D ?? FF 71 ?? FF 71 ?? 8D 41 ?? 50
            FF 71 ?? 6A ?? 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B 45 ?? 8B 55 ?? 85 C0
        }

        $encrypt_files_p2 = {
            75 ?? 89 55 ?? 21 45 ?? 8B CE 89 4D ?? 89 4D ?? EB ?? 8B 4D ?? 3B 4D ?? 0F 8D ?? ??
            ?? ?? 85 C0 0F 84 ?? ?? ?? ?? 85 C9 74 ?? 83 7D ?? ?? 74 ?? 8D 41 ?? 3B 45 ?? 74 ??
            8B C1 99 FF 75 ?? FF 75 ?? 52 50 E8 ?? ?? ?? ?? 8B C8 89 45 ?? C7 45 ?? ?? ?? ?? ??
            EB ?? 8B CA 81 E9 ?? ?? ?? ?? 89 4D ?? 8B 55 ?? 83 DA ?? 83 65 ?? ?? 89 55 ?? 6A ??
            8B 45 ?? FF 70 ?? 52 51 E8 ?? ?? ?? ?? 6A ?? 8B 4D ?? FF 71 ?? 52 50 E8 ?? ?? ?? ??
            8B C8 89 4D ?? 89 55 ?? 8B 45 ?? 2B C1 89 45 ?? 8B 4D ?? 1B CA 89 45 ?? 89 4D ?? EB
            ?? 8B 55 ?? 8B C2 C1 F8 ?? FF 75 ?? FF 75 ?? 52 68 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ??
            89 45 ?? 85 C0 75 ?? 50 FF 75 ?? FF 75 ?? 57 E8 ?? ?? ?? ?? 83 C4 ?? 57 FF 15 ?? ??
            ?? ?? 8B 75 ?? 8B 7D ?? 83 4D ?? ?? E8 ?? ?? ?? ?? FF 75 ?? FF 15 ?? ?? ?? ?? 8B 45
            ?? E8 ?? ?? ?? ?? C3 03 45 ?? 56 6A ?? 8D 4D ?? 51 50 FF 75 ?? 50 6A ?? 6A ?? 8D 85
            ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 85 C0 75 ?? 8B 45 ?? 40
            89 45 ?? 3B 45 ?? 75 ?? 8B 75 ?? FF 76 ?? FF 76 ?? 8B 45 ?? 03 45 ?? 03 45 ?? 50 E8
            ?? ?? ?? ?? FF 76 ?? FF 76 ?? 8B 46 ?? 03 45 ?? 03 45 ?? 03 45 ?? 50 E8 ?? ?? ?? ??
            83 C4 ?? 8B 7E ?? 03 7E ?? 03 7D ?? 03 7D ?? 8B 45 ?? 03 F8 8D 75 ?? A5 A5 A5 A5 6A
            ?? 50 FF 15 ?? ?? ?? ?? 8B 7D ?? 33 F6 46 FF 75 ?? FF 15 ?? ?? ?? ?? 8B 4D ?? 89 4D
            ?? 8B 55 ?? 8B 45 ?? E9 ?? ?? ?? ?? 53 8B 35 ?? ?? ?? ?? FF D6
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            $find_files
        ) and
        (
            $create_key
        ) and
        (
            all of ($encrypt_files_p*)
        )
}